

optimize_unconst <- function(dat, dat_train, dat_test, fmla){
 n = nrow(dat)
 
 fmla_a = fmla$fmla_a
 fmla_m = fmla$fmla_m
 fmla_y = fmla$fmla_y
 
 Xa = as.matrix(model.matrix(fmla_a, data=model.frame(dat, na.action = NULL)))
 Xm = as.matrix(model.matrix(fmla_m, data=model.frame(dat, na.action = NULL)))
 Xy = as.matrix(model.matrix(fmla_y, data=model.frame(dat, na.action = NULL)))
 A = dat$A
 M = dat$M 
 Y = dat$Y
 
 beta_y = lm(fmla_y, dat_train)$coefficients
 beta_m = glm(fmla_m, data=dat_train, family="binomial")$coefficients
 beta_a = glm(fmla_a, data=dat_train, family="binomial")$coefficients
 names(beta_m) = colnames(Xm)
 names(beta_y) = colnames(Xy)
 
 idx_y = c(1, match(attributes(beta_y)$names[-1], colnames(dat)))
 Yhat_test = as.matrix(dat_test[, idx_y])%*%beta_y
 
 
 # log likelihood p(Y, M, A | X) on train data
 p_Y = dnorm(Y, Xy%*%beta_y, 1)

 p_M1 = 1/(1+exp(-Xm%*%beta_m))
 p_M = M*p_M1 + (1-M)*(1-p_M1)
 
 p_A1 = 1/(1+exp(-Xa%*%beta_a))
 p_A = A*p_A1 + (1-A)*(1-p_A1)
 
 log_lik = sum(log(p_A) + log(p_M) + log(p_Y))  
 
 return(list(beta_a=beta_a, 
             beta_m=beta_m, 
             beta_y=beta_y, 
             mle=log_lik, 
             Yhat_test=Yhat_test))
}

